/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.debuffs;

import dev.toma.gunsrpg.common.debuffs.DebuffType;
import dev.toma.gunsrpg.common.debuffs.IDebuff;
import dev.toma.gunsrpg.common.debuffs.IDebuffBuilder;
import dev.toma.gunsrpg.common.debuffs.IDebuffContext;
import dev.toma.gunsrpg.common.debuffs.IDebuffType;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;

public class RespawnDebuffType<D extends IDebuff>
extends DebuffType<D> {
    private final int debuffDuration;

    private RespawnDebuffType(RespawnDebuffBuilder<D> builder) {
        super(builder);
        this.debuffDuration = ((RespawnDebuffBuilder)builder).debuffDuration;
    }

    public int getDebuffDuration() {
        return this.debuffDuration;
    }

    @Override
    public int getFlags() {
        return IDebuffType.TriggerFlags.RESPAWN.getValue();
    }

    @Override
    public D onTrigger(IDebuffContext context, Random random, @Nullable Object data) {
        return this.createRaw();
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    public static class RespawnDebuffBuilder<D extends IDebuff>
    implements IDebuffBuilder<D> {
        private int debuffDuration;
        private DebuffType.IFactory<D> factory;
        private BooleanSupplier stateSupplier;

        public RespawnDebuffBuilder<D> duration(int ticks) {
            this.debuffDuration = ticks;
            return this;
        }

        public RespawnDebuffBuilder<D> factory(DebuffType.IFactory<D> factory) {
            this.factory = factory;
            return this;
        }

        public RespawnDebuffBuilder<D> disableOn(BooleanSupplier supplier) {
            this.stateSupplier = supplier;
            return this;
        }

        public RespawnDebuffType<D> build() {
            return new RespawnDebuffType(this);
        }

        @Override
        public DebuffType.IFactory<D> getFactory() {
            return this.factory;
        }

        @Override
        public BooleanSupplier disabledStatusSupplier() {
            return this.stateSupplier;
        }
    }
}

